/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TagRemapper {
    private static final String TAG_NAMESPACE = "c";
    private static final Path DATA_DIR = Paths.get("C:\\Users\\mark\\Documents\\Modding\\1.16\\TechReborn\\src\\main\\resources\\data", new String[0]);
    private static final Path TAGS_DIR = DATA_DIR.resolve("c").resolve("tags");
    private static final Path BLOCK_TAGS_DIR = TAGS_DIR.resolve("blocks");
    private static final Path ITEM_TAGS_DIR = TAGS_DIR.resolve("items");
    private static final Path RECIPES_DIR = DATA_DIR.resolve("techreborn").resolve("recipes");

    public static void main(String[] args) throws IOException {
        TagRemapper.applyRenames(TagRemapper.getRenames(BLOCK_TAGS_DIR));
        TagRemapper.applyRenames(TagRemapper.getRenames(ITEM_TAGS_DIR));
    }

    private static void applyRenames(List<TagRename> renames) {
        renames.forEach(TagRemapper::applyRename);
    }

    private static void applyRename(TagRename rename) {
        try {
            Files.deleteIfExists(rename.getNewPath());
            Files.move(rename.getOldPath(), rename.getNewPath(), new CopyOption[0]);
            TagRemapper.applyToRecipes(rename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void applyToRecipes(TagRename rename) throws IOException {
        Files.walk(RECIPES_DIR, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".json")).forEach(TagRemapper.renameInFile(rename));
    }

    private static Consumer<Path> renameInFile(TagRename rename) {
        int quote = 34;
        return path -> {
            try {
                String recipe = Files.readString(path);
                recipe = recipe.replaceAll("\"" + rename.getOldTagName() + "\"", "\"" + rename.getNewTagName() + "\"");
                Files.writeString(path, (CharSequence)recipe, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static List<TagRename> getRenames(Path dir) throws IOException {
        return Files.list(dir).map(TagRename::new).collect(Collectors.toList());
    }

    private static class TagRename {
        final Path parent;
        final String oldName;
        final String newName;

        public TagRename(Path tag) {
            this.parent = tag.getParent();
            this.oldName = tag.getFileName().toString().replace(".json", "");
            this.newName = this.oldName + "s";
        }

        Path getOldPath() {
            return this.parent.resolve(this.oldName + ".json");
        }

        Path getNewPath() {
            return this.parent.resolve(this.newName + ".json");
        }

        String getOldTagName() {
            return "c:" + this.oldName;
        }

        String getNewTagName() {
            return "c:" + this.newName;
        }
    }
}

